#This function should run as an entity with tag "projectile"
#exit if the entity was destroyed
execute unless entity @s run return 0

## calculate new position
# save current z
execute store result score projectile_z astro_game.projectiles run data get entity @s Pos[2] 10000

# calculate distance to new position
scoreboard players operation distance_buffer astro_game.projectiles = base_step astro_game.obstacles
scoreboard players operation distance_buffer astro_game.projectiles *= speed astro_game.obstacles

# update current z
scoreboard players operation projectile_z astro_game.projectiles -= distance_buffer astro_game.projectiles

# apply new z
execute store result entity @s Pos[2] double 0.0001 run scoreboard players get projectile_z astro_game.projectiles

##Check if needs to destroy

# calculate min z
scoreboard players operation min_z astro_game.projectiles = projectile_z astro_game.projectiles
scoreboard players operation min_z astro_game.projectiles += distance_buffer astro_game.projectiles
# Cap min z to spaceship z in order to fail obstacles that are behind you
execute store result score spaceship_z astro_game.projectiles run data get entity @e[tag=spaceship,limit=1] Pos[2] 10000
execute if score min_z astro_game.projectiles < spaceship_z astro_game.projectiles run scoreboard players operation min_z astro_game.projectiles = spaceship_z astro_game.projectiles

# calculate max z
scoreboard players operation max_z astro_game.projectiles = projectile_z astro_game.projectiles
scoreboard players operation max_z astro_game.projectiles -= distance_buffer astro_game.projectiles

#Run a check on all obstacles in the same row, note that the function checks for the colision
execute positioned as @s positioned ~-1 ~-1 ~ as @e[dx=1,dy=1,dz=100,tag=obstacle] run function astro_game:spaceship/actions/turret/projectile/hit
execute if entity @s[tag=big_projectile] positioned as @s positioned ~-1 ~-1 ~ as @e[dx=1,dy=1,dz=100,tag=obstacle] run kill @s[tag=!non_lethal_obstacle]

##kill if reached the end
execute positioned as @s if entity @e[distance=0..3,tag=obstacle_spawner] run kill @s